<?php
session_start();

$base_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http'). '://' . $_SERVER['HTTP_HOST'] . '/';


/* ===== CONFIG DATABASE (CHỈ 1 GIÁ TRỊ) ===== */
$database = trim(file_get_contents( 'https://' . $_SERVER['SERVER_NAME'] . '/config.txt' ));
class CMSNT
{
    private $ketnoi;

    function connect()
    {
        global $database;

        if (!$this->ketnoi)
        {
            $this->ketnoi = mysqli_connect(
                'localhost',
                $database,
                $database,
                $database
            ) or die('Vui lòng kết nối đến DATABASE');

            mysqli_query($this->ketnoi, "SET NAMES 'utf8'");
        }
    }

    function dis_connect()
    {
        if ($this->ketnoi)
        {
            mysqli_close($this->ketnoi);
        }
    }

    function getUser($username)
    {
        $this->connect();
        $row = $this->ketnoi
            ->query("SELECT * FROM `users` WHERE `username` = '$username'")
            ->fetch_array();
        return $row;
    }

    function site($data)
    {
        $this->connect();
        $row = $this->ketnoi
            ->query("SELECT * FROM `options` WHERE `key` = '$data'")
            ->fetch_array();
        return $row['value'];
    }

    function query($sql)
    {
        $this->connect();
        return $this->ketnoi->query($sql);
    }

    function cong($table, $data, $sotien, $where)
    {
        $this->connect();
        return $this->ketnoi
            ->query("UPDATE `$table` SET `$data` = `$data` + '$sotien' WHERE $where");
    }

    function tru($table, $data, $sotien, $where)
    {
        $this->connect();
        return $this->ketnoi
            ->query("UPDATE `$table` SET `$data` = `$data` - '$sotien' WHERE $where");
    }

    function insert($table, $data)
    {
        $this->connect();
        $field_list = '';
        $value_list = '';

        foreach ($data as $key => $value)
        {
            $field_list .= ",$key";
            $value_list .= ",'" . mysqli_real_escape_string($this->ketnoi, $value) . "'";
        }

        $sql = 'INSERT INTO '.$table.' ('.trim($field_list, ',').')
                VALUES ('.trim($value_list, ',').')';

        return mysqli_query($this->ketnoi, $sql);
    }

    function update($table, $data, $where)
    {
        $this->connect();
        $sql = '';

        foreach ($data as $key => $value)
        {
            $sql .= "$key = '" . mysqli_real_escape_string($this->ketnoi, $value) . "',";
        }

        $sql = 'UPDATE '.$table.' SET '.trim($sql, ',').' WHERE '.$where;
        return mysqli_query($this->ketnoi, $sql);
    }

    function update_value($table, $data, $where, $limit)
    {
        $this->connect();
        $sql = '';

        foreach ($data as $key => $value)
        {
            $sql .= "$key = '" . mysqli_real_escape_string($this->ketnoi, $value) . "',";
        }

        $sql = 'UPDATE '.$table.' SET '.trim($sql, ',').' WHERE '.$where.' LIMIT '.$limit;
        return mysqli_query($this->ketnoi, $sql);
    }

    function remove($table, $where)
    {
        $this->connect();
        return mysqli_query($this->ketnoi, "DELETE FROM $table WHERE $where");
    }

    function get_list($sql)
    {
        $this->connect();
        $result = mysqli_query($this->ketnoi, $sql);

        if (!$result) die('Câu truy vấn bị sai');

        $data = [];
        while ($row = mysqli_fetch_assoc($result))
        {
            $data[] = $row;
        }

        mysqli_free_result($result);
        return $data;
    }

    function get_row($sql)
    {
        $this->connect();
        $result = mysqli_query($this->ketnoi, $sql);

        if (!$result) die('Câu truy vấn bị sai');

        $row = mysqli_fetch_assoc($result);
        mysqli_free_result($result);
        return $row ? $row : false;
    }

    function num_rows($sql)
    {
        $this->connect();
        $result = mysqli_query($this->ketnoi, $sql);

        if (!$result) die('Câu truy vấn bị sai');

        $num = mysqli_num_rows($result);
        mysqli_free_result($result);
        return $num;
    }
}

/* ===== CHECK LOGIN ===== */
if (isset($_SESSION['username']))
{
    $CMSNT = new CMSNT;
    $getUser = $CMSNT->get_row(
        "SELECT * FROM users WHERE username = '".$_SESSION['username']."'"
    );

    $my_username = true;
    $my_money = $getUser['money'];
    $my_level = $getUser['level'];

    if ($getUser['money'] < 0)
    {
        $CMSNT->update("users", ['banned' => 1],
            "username = '".$_SESSION['username']."'");
        session_destroy();
        header('location: /');
        die();
    }
}
else
{
    $my_level = null;
    $my_money = 0;
}

/* ===== FUNCTIONS ===== */
function CheckLogin()
{
    global $my_username;
    if ($my_username !== true)
    {
        header('Location: /');
        exit;
    }
}

function CheckAdmin()
{
    global $my_level;
    if (!in_array($my_level, ['admin', 'ctv']))
    {
        header('Location: /');
        exit;
    }
}
